<?php
/**
 * Admin Panel Configuration
 * Configuration settings for the admin panel
 */

// Admin credentials (change these!)
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', 'admin123'); // Change this!

// Admin panel settings
define('ADMIN_SESSION_TIMEOUT', 3600); // 1 hour
define('ADMIN_MAX_LOGIN_ATTEMPTS', 5);
define('ADMIN_LOCKOUT_TIME', 900); // 15 minutes

// Pagination settings
define('ADMIN_ITEMS_PER_PAGE', 20);
define('ADMIN_MAX_ITEMS_PER_PAGE', 100);

// Log settings
define('ADMIN_LOG_LEVEL', 'INFO');
define('ADMIN_LOG_RETENTION_DAYS', 30);

// Security settings
define('ADMIN_CSRF_TOKEN_NAME', 'admin_csrf_token');
define('ADMIN_PASSWORD_MIN_LENGTH', 8);

// Bot settings
define('BOT_MAX_CONNECTIONS', 100);
define('BOT_RATE_LIMIT', 30);
define('BOT_RESPONSE_DELAY', 1);

// Broadcast settings
define('BROADCAST_MAX_MESSAGE_LENGTH', 4000);
define('BROADCAST_MAX_RECIPIENTS', 10000);
define('BROADCAST_RATE_LIMIT', 30); // messages per minute

// File upload settings
define('ADMIN_MAX_UPLOAD_SIZE', 5242880); // 5MB
define('ADMIN_ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'txt']);

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Error reporting (disable in production)
if (defined('DEBUG') && DEBUG) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Helper functions
function admin_hash_password($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}

function admin_verify_password($password, $hash) {
    return password_verify($password, $hash);
}

function admin_generate_csrf_token() {
    if (!isset($_SESSION['admin_csrf_token'])) {
        $_SESSION['admin_csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['admin_csrf_token'];
}

function admin_verify_csrf_token($token) {
    return isset($_SESSION['admin_csrf_token']) && hash_equals($_SESSION['admin_csrf_token'], $token);
}

function admin_redirect($url) {
    header('Location: ' . $url);
    exit;
}

function admin_json_response($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

function admin_log($level, $message, $context = []) {
    $logFile = dirname(__DIR__, 2) . '/logs/admin_' . date('Y-m-d') . '.log';
    $logEntry = date('Y-m-d H:i:s') . " [$level] $message";
    if (!empty($context)) {
        $logEntry .= ' ' . json_encode($context);
    }
    $logEntry .= PHP_EOL;
    file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
}

// Initialize session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}