<?php
/**
 * Admin Panel - Main Entry Point
 * Modern, modular admin interface
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set timezone
date_default_timezone_set('Asia/Jakarta');

// Start session first
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Simple authentication check
$is_logged_in = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;

// Handle login
if (!$is_logged_in) {
    if (isset($_POST['username']) && isset($_POST['password'])) {
        $username = $_POST['username'];
        $password = $_POST['password'];
        
        // Simple authentication (change these!)
        if ($username === 'admin' && $password === 'admin123') {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $username;
            header('Location: index.php');
            exit;
        } else {
            $login_error = 'Invalid credentials';
        }
    }
    
    // Show login form
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Login - Telegram Bot</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <style>
            body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
            .login-card { backdrop-filter: blur(10px); background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2); }
        </style>
    </head>
    <body class="d-flex align-items-center justify-content-center">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-4">
                    <div class="card login-card shadow-lg border-0">
                        <div class="card-body p-5">
                            <div class="text-center mb-4">
                                <i class="fas fa-robot fa-3x text-white mb-3"></i>
                                <h3 class="text-white">Admin Login</h3>
                                <p class="text-white-50">Telegram Bot Management</p>
                            </div>
                            
                            <?php if (isset($login_error)): ?>
                                <div class="alert alert-danger" role="alert">
                                    <i class="fas fa-exclamation-triangle me-2"></i><?= $login_error ?>
                                </div>
                            <?php endif; ?>
                            
                            <form method="POST">
                                <div class="mb-3">
                                    <label class="form-label text-white">Username</label>
                                    <input type="text" class="form-control" name="username" placeholder="Enter username" required>
                                </div>
                                <div class="mb-4">
                                    <label class="form-label text-white">Password</label>
                                    <input type="password" class="form-control" name="password" placeholder="Enter password" required>
                                </div>
                                <button type="submit" class="btn btn-light w-100 py-2">
                                    <i class="fas fa-sign-in-alt me-2"></i>Login
                                </button>
                            </form>
                            
                            <div class="text-center mt-4">
                                <small class="text-white-50">Default: admin / admin123</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}

// Get current section
$currentSection = $_GET['section'] ?? 'dashboard';

// Try to load database and classes if available
$database = null;
$logger = null;
$authManager = null;
$adminController = null;

try {
    require_once '../config/database.php';
    require_once '../classes/DatabaseLogger.php';
    
    $database = new Database();
    $logger = new DatabaseLogger($database->getConnection(), 'admin');
    
    // Try to load admin classes
    if (file_exists('includes/AuthManager.php')) {
        require_once 'includes/AuthManager.php';
        $authManager = new AuthManager($database->getConnection());
    } else {
        $authManager = null;
    }
    
    if (file_exists('includes/AdminController.php')) {
        // Load BotManager and BroadcastManager first
        if (file_exists('includes/BotManager.php')) {
            require_once 'includes/BotManager.php';
        }
        if (file_exists('includes/BroadcastManager.php')) {
            require_once 'includes/BroadcastManager.php';
        }
        
        require_once 'includes/AdminController.php';
        $adminController = new AdminController($database->getConnection(), $logger);
        
        // Get initial data
        $stats = $adminController->getStats();
        $recentLogs = $adminController->getLogs('bot', 20);
        $systemLogs = $adminController->getLogs('system', 20);
        $logSettings = $adminController->getLogSettings();
    } else {
        $adminController = null;
        $stats = [
            'total_users' => 0,
            'total_searches' => 0,
            'total_ad_clicks' => 0,
            'recent_activity' => 0
        ];
        $recentLogs = [];
        $systemLogs = [];
        $logSettings = [];
    }
} catch (Exception $e) {
    // Fallback data if database is not available
    $database = null;
    $logger = null;
    $authManager = null;
    $adminController = null;
    $stats = [
        'total_users' => 0,
        'total_searches' => 0,
        'total_ad_clicks' => 0,
        'recent_activity' => 0
    ];
    $recentLogs = [];
    $systemLogs = [];
    $logSettings = [];
}

// Handle AJAX requests
if (isset($_GET['action'])) {
    if ($adminController) {
        $adminController->handleAjaxRequest($_GET['action']);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Admin controller not available']);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Telegram Bot</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    
    <!-- Custom CSS -->
    <link href="assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <!-- Sidebar -->
    <?php include 'templates/sidebar.php'; ?>
    
    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <?php
        switch ($currentSection) {
            case 'dashboard':
                include 'templates/dashboard.php';
                break;
            case 'users':
                include 'templates/users.php';
                break;
            case 'logs':
                include 'templates/logs.php';
                break;
            case 'settings':
                include 'templates/settings.php';
                break;
            case 'analytics':
                include 'templates/analytics.php';
                break;
            case 'bot_management':
                include 'templates/bot_management.php';
                break;
            case 'broadcast':
                include 'templates/broadcast.php';
                break;
            default:
                include 'templates/dashboard.php';
                break;
        }
        ?>
    </div>
    
    <!-- Modals -->
    <?php include 'templates/modals.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script src="assets/js/admin.js"></script>
    <script src="assets/js/bot-management.js"></script>
    <script src="assets/js/broadcast.js"></script>
    
    <script>
        // Check if admin controller is available
        const hasAdminController = <?= $adminController ? 'true' : 'false' ?>;
        const hasDatabase = <?= $database ? 'true' : 'false' ?>;
        
        if (!hasAdminController || !hasDatabase) {
            // Show warning if admin controller or database is not available
            document.addEventListener('DOMContentLoaded', function() {
                const mainContent = document.getElementById('mainContent');
                if (mainContent) {
                    const warning = document.createElement('div');
                    warning.className = 'alert alert-warning alert-dismissible fade show';
                    let message = '';
                    
                    if (!hasDatabase) {
                        message = '<strong>Database not available!</strong> Some features may not work properly.';
                    } else if (!hasAdminController) {
                        message = '<strong>Admin controller not available!</strong> Some features may not work properly.';
                    } else {
                        message = '<strong>Some components not available!</strong> Some features may not work properly.';
                    }
                    
                    warning.innerHTML = `
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    `;
                    mainContent.insertBefore(warning, mainContent.firstChild);
                }
            });
        }
    </script>
</body>
</html>