<!-- Bot Management Section -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-white">Bot Management</h2>
    <div class="btn-group">
        <button class="btn btn-info" onclick="checkBotConnection()" id="checkConnectionBtn">
            <i class="fas fa-wifi me-2"></i>Cek Koneksi Bot
        </button>
        <button class="btn btn-primary" onclick="refreshBotStatus()">
            <i class="fas fa-sync-alt me-2"></i>Refresh
        </button>
    </div>
</div>

<!-- Bot Status Card -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-robot me-2"></i>Bot Status
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-3">
                            <span class="status-indicator" id="botStatusIndicator"></span>
                            <span class="ms-2" id="botStatusText">Checking...</span>
                        </div>
                        <div class="mb-3">
                            <strong>Last Check:</strong> <span id="botLastCheck">-</span>
                        </div>
                        <div class="mb-3" id="connectionStatus" style="display: none;">
                            <div class="alert alert-info mb-2" id="connectionAlert">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Connection Status:</strong> <span id="connectionStatusText">Checking...</span>
                            </div>
                            
                            <!-- Bot Information -->
                            <div id="botInfoSection" style="display: none;">
                                <div class="card mb-2">
                                    <div class="card-header py-2">
                                        <h6 class="mb-0">
                                            <i class="fab fa-telegram me-2"></i>Bot Information
                                        </h6>
                                    </div>
                                    <div class="card-body py-2">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <strong>Username:</strong> <span id="botUsername">-</span><br>
                                                <strong>Name:</strong> <span id="botName">-</span><br>
                                                <strong>Bot ID:</strong> <span id="botId">-</span>
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Groups:</strong> <span id="botGroups">-</span><br>
                                                <strong>Inline Queries:</strong> <span id="botInline">-</span><br>
                                                <strong>Read All Messages:</strong> <span id="botReadAll">-</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Webhook Information -->
                            <div id="webhookInfoSection" style="display: none;">
                                <div class="card mb-2">
                                    <div class="card-header py-2">
                                        <h6 class="mb-0">
                                            <i class="fas fa-link me-2"></i>Webhook Information
                                        </h6>
                                    </div>
                                    <div class="card-body py-2">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <strong>URL:</strong> <span id="webhookUrl">-</span><br>
                                                <strong>Pending Updates:</strong> <span id="webhookPending">-</span><br>
                                                <strong>Max Connections:</strong> <span id="webhookMaxConn">-</span>
                                            </div>
                                            <div class="col-md-6">
                                                <strong>Custom Certificate:</strong> <span id="webhookCert">-</span><br>
                                                <strong>Last Error:</strong> <span id="webhookError">-</span><br>
                                                <strong>Allowed Updates:</strong> <span id="webhookUpdates">-</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Technical Details -->
                            <div class="small text-muted">
                                <strong>Response Time:</strong> <span id="responseTime">-</span>ms<br>
                                <strong>Last Ping:</strong> <span id="lastPing">-</span>
                            </div>
                        </div>
                        <div class="btn-group">
                            <button class="btn btn-success" onclick="controlBot('start')" id="startBotBtn">
                                <i class="fas fa-play me-2"></i>Start Bot
                            </button>
                            <button class="btn btn-warning" onclick="controlBot('stop')" id="stopBotBtn">
                                <i class="fas fa-stop me-2"></i>Stop Bot
                            </button>
                            <button class="btn btn-info" onclick="controlBot('restart')" id="restartBotBtn">
                                <i class="fas fa-redo me-2"></i>Restart Bot
                            </button>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h4 text-primary" id="totalCommands">0</div>
                                    <small class="text-muted">Commands Today</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <div class="h4 text-success" id="avgResponseTime">0ms</div>
                                    <small class="text-muted">Avg Response</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bot Configuration -->
<div class="row mb-4">
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cog me-2"></i>Bot Configuration
                </h5>
            </div>
            <div class="card-body">
                <form id="botConfigForm">
                    <div class="mb-3">
                        <label class="form-label">Max Connections</label>
                        <input type="number" class="form-control" name="max_connections" min="1" max="1000">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Rate Limit (per minute)</label>
                        <input type="number" class="form-control" name="rate_limit" min="1" max="1000">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Response Delay (seconds)</label>
                        <input type="number" class="form-control" name="response_delay" min="0" max="10" step="0.1">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Log Level</label>
                        <select class="form-select" name="log_level">
                            <option value="DEBUG">DEBUG</option>
                            <option value="INFO">INFO</option>
                            <option value="WARNING">WARNING</option>
                            <option value="ERROR">ERROR</option>
                            <option value="CRITICAL">CRITICAL</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="auto_restart" id="autoRestart">
                            <label class="form-check-label" for="autoRestart">
                                Auto Restart on Failure
                            </label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="maintenance_mode" id="maintenanceMode">
                            <label class="form-check-label" for="maintenanceMode">
                                Maintenance Mode
                            </label>
                        </div>
                    </div>
                    <button type="button" class="btn btn-primary" onclick="saveBotConfig()">
                        <i class="fas fa-save me-2"></i>Save Configuration
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-terminal me-2"></i>Command Management
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Command</th>
                                <th>Status</th>
                                <th>Rate Limit</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="botCommandsTable">
                            <tr>
                                <td colspan="4" class="text-center">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    <div class="mt-2">Loading commands...</div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Bot Logs -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>Recent Bot Logs
                </h5>
            </div>
            <div class="card-body">
                <div class="log-container" id="botLogsContainer">
                    <div class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <div class="mt-2">Loading bot logs...</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>