<!-- Dashboard Section -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="text-white mb-1">Dashboard</h2>
        <p class="text-white-50 mb-0">Welcome back, <?= $_SESSION['admin_username'] ?? 'Admin' ?>!</p>
    </div>
    <div class="d-flex align-items-center">
        <span class="text-white-50 me-3">
            <i class="fas fa-clock me-2"></i>
            <span id="currentTime"></span>
        </span>
        <button class="btn btn-outline-light" onclick="refreshData()">
            <i class="fas fa-sync-alt me-2"></i>Refresh
        </button>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card fade-in">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-number" id="totalUsers"><?= number_format($stats['total_users']) ?></div>
                        <div class="stat-label">Total Users</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card fade-in">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-number" id="totalSearches"><?= number_format($stats['total_searches']) ?></div>
                        <div class="stat-label">Total Searches</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-search"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card fade-in">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-number" id="totalAdClicks"><?= number_format($stats['total_ad_clicks']) ?></div>
                        <div class="stat-label">Ad Clicks</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-mouse-pointer"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stat-card fade-in">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-number" id="recentActivity"><?= number_format($stats['recent_activity']) ?></div>
                        <div class="stat-label">Recent Activity</div>
                    </div>
                    <div class="stat-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>Activity Overview
                </h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="activityChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-pie-chart me-2"></i>Distribution
                </h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="distributionChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>Recent Activity
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Time</th>
                                <th>Type</th>
                                <th>User</th>
                                <th>Action</th>
                                <th>Details</th>
                            </tr>
                        </thead>
                        <tbody id="recentActivityTable">
                            <?php foreach (array_slice($recentLogs, 0, 10) as $log): ?>
                            <tr>
                                <td><?= date('H:i:s', strtotime($log['created_at'])) ?></td>
                                <td>
                                    <span class="badge bg-<?= $log['log_type'] === 'ad_click' ? 'success' : 'info' ?>">
                                        <?= ucfirst($log['log_type']) ?>
                                    </span>
                                </td>
                                <td><?= $log['username'] ?? 'N/A' ?></td>
                                <td><?= $log['action'] ?? 'N/A' ?></td>
                                <td><?= substr($log['details'] ?? '', 0, 50) ?>...</td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>