<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel Error</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            min-height: 100vh; 
        }
        .error-card { 
            backdrop-filter: blur(10px); 
            background: rgba(255,255,255,0.95); 
            border: 1px solid rgba(255,255,255,0.2); 
        }
    </style>
</head>
<body class="d-flex align-items-center justify-content-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card error-card shadow-lg border-0">
                    <div class="card-body p-5 text-center">
                        <i class="fas fa-exclamation-triangle fa-4x text-danger mb-4"></i>
                        <h3 class="text-danger mb-3">Database Connection Error</h3>
                        <p class="text-muted mb-4">
                            <?= isset($db_error) ? $db_error : 'Unable to connect to database' ?>
                        </p>
                        
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Possible Solutions:</h6>
                            <ul class="text-start mb-0">
                                <li>Check database credentials in <code>config/database.php</code></li>
                                <li>Ensure database server is running</li>
                                <li>Verify database name and user permissions</li>
                                <li>Check if database tables exist</li>
                            </ul>
                        </div>
                        
                        <div class="mt-4">
                            <a href="status.php" class="btn btn-outline-primary me-2">
                                <i class="fas fa-check-circle me-2"></i>Check Status
                            </a>
                            <a href="../admin.php" class="btn btn-primary">
                                <i class="fas fa-arrow-left me-2"></i>Use Old Admin
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
