<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Telegram Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            min-height: 100vh; 
        }
        .login-card { 
            backdrop-filter: blur(10px); 
            background: rgba(255,255,255,0.1); 
            border: 1px solid rgba(255,255,255,0.2); 
        }
        .glass-effect { 
            background: rgba(255,255,255,0.1); 
            backdrop-filter: blur(10px); 
            border: 1px solid rgba(255,255,255,0.2); 
        }
    </style>
</head>
<body class="d-flex align-items-center justify-content-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card login-card shadow-lg border-0">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <i class="fas fa-robot fa-3x text-white mb-3"></i>
                            <h3 class="text-white">Admin Login</h3>
                            <p class="text-white-50">Telegram Bot Management</p>
                        </div>
                        
                        <?php if (isset($login_error)): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i><?= $login_error ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label text-white">Username</label>
                                <div class="input-group">
                                    <span class="input-group-text glass-effect border-0">
                                        <i class="fas fa-user text-white"></i>
                                    </span>
                                    <input type="text" class="form-control glass-effect border-0 text-white" 
                                           name="username" placeholder="Enter username" required>
                                </div>
                            </div>
                            <div class="mb-4">
                                <label class="form-label text-white">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text glass-effect border-0">
                                        <i class="fas fa-lock text-white"></i>
                                    </span>
                                    <input type="password" class="form-control glass-effect border-0 text-white" 
                                           name="password" placeholder="Enter password" required>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-light w-100 py-2">
                                <i class="fas fa-sign-in-alt me-2"></i>Login
                            </button>
                        </form>
                        
                        <div class="text-center mt-4">
                            <small class="text-white-50">Default: admin / admin123</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>