<!-- Settings Section -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-white">System Settings</h2>
    <button class="btn btn-primary" onclick="saveSettings()">
        <i class="fas fa-save me-2"></i>Save Settings
    </button>
</div>

<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cog me-2"></i>Log Settings
                </h5>
            </div>
            <div class="card-body">
                <form id="settingsForm">
                    <div class="mb-3">
                        <label class="form-label">Auto Reset (hours)</label>
                        <input type="number" class="form-control" name="auto_reset_hours" 
                               value="<?= $logSettings['auto_reset_hours'] ?? '24' ?>" min="0" max="168">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Max Log Entries</label>
                        <input type="number" class="form-control" name="max_log_entries" 
                               value="<?= $logSettings['max_log_entries'] ?? '10000' ?>" min="100" max="100000">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Retention Days</label>
                        <input type="number" class="form-control" name="log_retention_days" 
                               value="<?= $logSettings['log_retention_days'] ?? '30' ?>" min="1" max="365">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Log Level</label>
                        <select class="form-select" name="log_level">
                            <option value="DEBUG" <?= ($logSettings['log_level'] ?? 'INFO') === 'DEBUG' ? 'selected' : '' ?>>DEBUG</option>
                            <option value="INFO" <?= ($logSettings['log_level'] ?? 'INFO') === 'INFO' ? 'selected' : '' ?>>INFO</option>
                            <option value="WARNING" <?= ($logSettings['log_level'] ?? 'INFO') === 'WARNING' ? 'selected' : '' ?>>WARNING</option>
                            <option value="ERROR" <?= ($logSettings['log_level'] ?? 'INFO') === 'ERROR' ? 'selected' : '' ?>>ERROR</option>
                            <option value="CRITICAL" <?= ($logSettings['log_level'] ?? 'INFO') === 'CRITICAL' ? 'selected' : '' ?>>CRITICAL</option>
                        </select>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>System Info
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="text-center">
                            <div class="h4 text-primary"><?= PHP_VERSION ?></div>
                            <small class="text-muted">PHP Version</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-center">
                            <div class="h4 text-success"><?= date('Y-m-d') ?></div>
                            <small class="text-muted">Last Update</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>