<?php
/**
 * Application Configuration Manager
 * Centralized configuration management using database
 */

class AppConfig {
    private static $config = [];
    private static $loaded = false;
    
    /**
     * Load configuration from database
     */
    public static function load() {
        if (self::$loaded) {
            return self::$config;
        }
        
        try {
            // Try to load from database
            if (file_exists(__DIR__ . '/database.php')) {
                require_once __DIR__ . '/database.php';
                $database = new Database();
                $pdo = $database->getConnection();
                
                // Load bot_settings
                try {
                    $stmt = $pdo->query("SELECT setting_name, setting_value FROM bot_settings");
                    while ($row = $stmt->fetch()) {
                        self::$config[$row['setting_name']] = $row['setting_value'];
                    }
                } catch (Exception $e) {
                    // Table might not exist yet
                }
                
                // Load app_settings if exists
                try {
                    $stmt = $pdo->query("SELECT setting_name, setting_value FROM app_settings");
                    while ($row = $stmt->fetch()) {
                        self::$config[$row['setting_name']] = $row['setting_value'];
                    }
                } catch (Exception $e) {
                    // Table might not exist yet
                }
            }
            
            // Fallback to hosting_config if available
            if (file_exists(__DIR__ . '/hosting_config.php')) {
                require_once __DIR__ . '/hosting_config.php';
                
                // Database config
                self::$config['DB_HOST'] = 'localhost';
                self::$config['DB_NAME'] = 'andn3765_bottele';
                self::$config['DB_USER'] = 'andn3765_bottele';
                self::$config['DB_PASS'] = 'andn3765_bottele';
            }
            
            // Fallback to hardcoded values
            if (empty(self::$config['BOT_TOKEN'])) {
                self::$config['BOT_TOKEN'] = '7116738691:AAFw-vLy8xYoDNg5urgHrj_pyVKKHT-vw8w';
            }
            
            if (empty(self::$config['WEBHOOK_URL'])) {
                self::$config['WEBHOOK_URL'] = 'https://bot.apivalidasi.my.id/telegram_bot.php';
            }
            
            if (empty(self::$config['DOMAIN'])) {
                self::$config['DOMAIN'] = 'https://bot.apivalidasi.my.id';
            }
            
            if (empty(self::$config['PUBLIC_DOMAIN'])) {
                self::$config['PUBLIC_DOMAIN'] = 'https://bot.apivalidasi.my.id/public';
            }
            
            if (empty(self::$config['ADULT_API_URL'])) {
                self::$config['ADULT_API_URL'] = 'https://tes.apivalidasi.my.id/api_adult.php';
            }
            
            self::$loaded = true;
            
        } catch (Exception $e) {
            error_log("Error loading app config: " . $e->getMessage());
            self::$loaded = true; // Set to true to prevent infinite loop
        }
        
        return self::$config;
    }
    
    /**
     * Get configuration value
     */
    public static function get($key, $default = null) {
        if (!self::$loaded) {
            self::load();
        }
        
        return self::$config[$key] ?? $default;
    }
    
    /**
     * Set configuration value
     */
    public static function set($key, $value) {
        if (!self::$loaded) {
            self::load();
        }
        
        self::$config[$key] = $value;
    }
    
    /**
     * Get all configuration
     */
    public static function all() {
        if (!self::$loaded) {
            self::load();
        }
        
        return self::$config;
    }
    
    /**
     * Check if configuration exists
     */
    public static function has($key) {
        if (!self::$loaded) {
            self::load();
        }
        
        return isset(self::$config[$key]);
    }
}
