<?php
// Tetapkan batas waktu untuk mencegah skrip berjalan terlalu lama
set_time_limit(30);

// Set CORS dan security headers terlebih dahulu
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Cross-Origin-Embedder-Policy: unsafe-none');
header('Cross-Origin-Opener-Policy: unsafe-none');
header('Cross-Origin-Resource-Policy: cross-origin');
header('Cache-Control: public, max-age=3600');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Ambil URL gambar dari parameter 'l'
$imageUrl = isset($_GET['l']) ? $_GET['l'] : null;

// Validasi dasar: pastikan URL tidak kosong dan formatnya valid
if (empty($imageUrl) || !filter_var($imageUrl, FILTER_VALIDATE_URL)) {
    // Jika tidak valid, kirim header 400 Bad Request dan keluar
    header("HTTP/1.1 400 Bad Request");
    echo "URL gambar tidak valid.";
    exit;
}

// Inisialisasi sesi cURL
$ch = curl_init();

// Siapkan header kustom untuk meniru permintaan browser
// Ini sangat penting untuk melewati beberapa jenis perlindungan hotlink.
$headers = [
    'Origin: https://poster.lk21.party',
    'Referer: https://poster.lk21.party/', // Menggunakan domain utama sebagai referer adalah praktik umum.
    'Priority: u=4, i',
    'Accept: image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8',
    'Accept-Language: en-US,en;q=0.9',
    'Accept-Encoding: gzip, deflate, br',
    'DNT: 1',
    'Connection: keep-alive',
    'Upgrade-Insecure-Requests: 1'
];

// Atur opsi cURL
curl_setopt($ch, CURLOPT_URL, $imageUrl); // Atur URL yang akan diambil
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // Kembalikan transfer sebagai string
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); // Waktu habis untuk koneksi
curl_setopt($ch, CURLOPT_TIMEOUT, 20); // Waktu habis untuk seluruh operasi
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Ikuti pengalihan
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Jangan verifikasi sertifikat SSL (berguna untuk beberapa server)
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Tambahkan header kustom
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'); // User agent modern

// Jalankan permintaan cURL
$imageData = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);

// Tutup sesi cURL
curl_close($ch);

// Periksa apakah permintaan berhasil dan kita mendapatkan data gambar
if ($httpCode == 200 && !empty($imageData) && strpos($contentType, 'image/') !== false) {
    // Jika berhasil, kirim header tipe konten yang benar
    header('Content-Type: ' . $contentType);
    header('Content-Length: ' . strlen($imageData));
    
    // Keluarkan data gambar
    echo $imageData;
} else {
    // Jika gagal, alihkan ke gambar placeholder.
    // Ini memberikan pengalaman pengguna yang lebih baik daripada gambar rusak.
    header('Location: https://placehold.co/500x750/141414/FFFFFF?text=Image+Failed');
    exit;
}
?>
