<?php
// player.php
// Mode proxy untuk HLS segmen/playlist -> ?proxy=1&u=<url>
// Mode player -> otomatis ambil src & poster dari API ?id=...

// PERLINDUNGAN ANTI-CURL/BOT SEDERHANA (untuk Mode Player)
// Memerlukan User-Agent dan header Accept. Browser selalu mengirim ini,
// sementara cURL/bot sederhana seringkali tidak.
// Ini tidak berlaku untuk mode proxy, yang punya perlindungan sendiri di bawah.
if (!isset($_GET['proxy']) && (!isset($_SERVER['HTTP_USER_AGENT']) || !isset($_SERVER['HTTP_ACCEPT']))) {
    http_response_code(403);
    die('Akses ditolak. Silakan gunakan browser.');
}

error_reporting(0); // Sembunyikan error

// Mengizinkan file ini di-embed di situs web mana pun.
header("Content-Security-Policy: frame-ancestors *");

// ====== Fungsi Helper untuk mengubah URL relatif ke absolut ======
function abs_url($url, $base) {
    if ($url === '') return $url;
    // Jika sudah absolut
    if (preg_match('#^[a-z][a-z0-9+.-]*://#i', $url)) return $url;
    // Jika protokol-relatif (//domain.com)
    if (strpos($url, '//') === 0) {
        $sch = parse_url($base, PHP_URL_SCHEME) ?: 'https';
        return $sch . $url;
    }
    // Jika root-relatif (/path/file)
    if ($url[0] === '/') {
        $p = parse_url($base);
        $port = isset($p['port']) ? ':' . $p['port'] : '';
        return $p['scheme'] . '://' . $p['host'] . $port . $url;
    }
    // Jika path-relatif (file.ts atau ../file.ts)
    $p = parse_url($base);
    $path = $p['path'] ?? '/';
    // Hapus nama file dari path, sisakan direktorinya
    $path = preg_replace('#/[^/]*$#', '/', $path);
    return $p['scheme'] . '://' . $p['host'] . (isset($p['port']) ? ':' . $p['port'] : '') . $path . $url;
}

// ===================================
// ====== MODE PROXY ======
// ===================================
if (isset($_GET['proxy']) && $_GET['proxy'] === '1') {
    
    // PERLINDUNGAN ANTI-LEECHING (Penyalahgunaan Proxy)
    // Memastikan bahwa permintaan ke proxy HANYA datang dari domain ini sendiri (Referer check).
    // Ini mencegah situs lain menggunakan server Anda sebagai proxy mereka.
    $self_domain = str_replace('www.', '', $_SERVER['HTTP_HOST']);
    $referer_host = str_replace('www.', '', parse_url($_SERVER['HTTP_REFERER'] ?? '', PHP_URL_HOST));

    if ($referer_host !== $self_domain) {
        http_response_code(403);
        die('Akses proxy dilarang.');
    }
    
    $url = $_GET['u'] ?? '';
    if ($url === '') {
        http_response_code(400);
        echo "Parameter 'u' (URL) tidak ditemukan.";
        exit;
    }

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.0.0 Safari/537.36',
        // Memalsukan Referer untuk bypass proteksi hotlink
        CURLOPT_HTTPHEADER     => ['Referer: https://cloud.hownetwork.xyz/']
    ]);

    $data = curl_exec($ch);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || !$data) {
        http_response_code(502); // Bad Gateway
        echo "Gagal mengambil konten dari server asli.";
        exit;
    }

    // Periksa apakah ini file playlist .m3u8
    $isM3U8 = (stripos($contentType, 'mpegurl') !== false) || (preg_match('#\.m3u8($|\?)#i', $url));

    if ($isM3U8) {
        // Jika ini playlist, kita perlu memodifikasi semua URL di dalamnya
        header('Content-Type: application/vnd.apple.mpegurl');
        $outputLines = [];
        $lines = preg_split('/\r\n|\r|\n/', $data);

        foreach ($lines as $line) {
            $trimmedLine = trim($line);
            if ($trimmedLine === '' || $trimmedLine[0] === '#') {
                // Ini adalah baris komentar, tapi periksa URI (untuk key)
                if (preg_match('/URI="([^"]+)"/i', $trimmedLine, $matches)) {
                    $keyUrl = $matches[1];
                    $absKeyUrl = abs_url($keyUrl, $url);
                    $proxyKeyUrl = $_SERVER['PHP_SELF'] . '?proxy=1&u=' . rawurlencode($absKeyUrl);
                    $line = str_replace($keyUrl, $proxyKeyUrl, $line);
                }
                $outputLines[] = $line;
            } else {
                // Ini adalah URL segmen .ts atau playlist lain
                $absSegmentUrl = abs_url($trimmedLine, $url);
                $proxySegmentUrl = $_SERVER['PHP_SELF'] . '?proxy=1&u=' . rawurlencode($absSegmentUrl);
                $outputLines[] = $proxySegmentUrl;
            }
        }
        echo implode("\n", $outputLines);
    } else {
        // Jika ini bukan playlist (misal, segmen .ts atau file key)
        if ($contentType) {
            header("Content-Type: $contentType");
        }
        echo $data;
    }
    exit; // Selesai, jangan proses ke Mode Pemutar
}


// ===================================
// ====== MODE PEMUTAR (PLAYER) ======
// ===================================

$id = $_GET['id'] ?? '';
$src = '';
$poster = '';
$title = 'Video Player';

if ($id !== '') {
    $api_url = "https://cloud.hownetwork.xyz/api.php?id=" . rawurlencode($id);
    $ch_api = curl_init($api_url);
    
    // PERBAIKAN: Menambahkan User-Agent dan Referer ke panggilan API
    curl_setopt_array($ch_api, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.0.0 Safari/537.36',
        CURLOPT_HTTPHEADER     => ['Referer: https://cloud.hownetwork.xyz/']
    ]);
    
    $response_api = curl_exec($ch_api);
    curl_close($ch_api);

    if ($response_api) {
        $json_data = json_decode($response_api, true);
        if (isset($json_data['file']))   $src    = $json_data['file'];
        if (isset($json_data['poster'])) $poster = $json_data['poster'];
        if (isset($json_data['title']))  $title  = $json_data['title'];
    }
}

// Coba fallback ke parameter 'src' manual jika ada
if ($src === '') {
    $src = $_GET['src'] ?? '';
}

// Jika masih kosong juga, tampilkan error
if ($src === '') {
    http_response_code(404);
    echo "Video tidak ditemukan. Pastikan parameter ?id= atau ?src= sudah benar.";
    exit;
}

// Buat URL Proxy
$proxyUrl = $_SERVER['PHP_SELF'] . '?proxy=1&u=' . rawurlencode($src);
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?></title>
    
    <!-- 1. Muat CSS Plyr --><link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" />
    <!-- 2. Muat Font Awesome untuk ikon Telegram --><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" xintegrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0V4LLanw2qksYuJBOQ+EqBfQC8c6T6c1C1a4P0wEw2N0XJ2M3K1P2K1bYQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <style>
        /* Buat player fullscreen */
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            width: 100%;
            overflow: hidden; /* Sembunyikan scrollbar */
            background-color: #000;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        /* Target untuk Plyr */
        .plyr__video-wrapper,
        .plyr {
            width: 100%;
            height: 100%;
            --plyr-video-background: #000;
        }

        /* Styling Watermark */
        .watermark {
            position: absolute; 
            top: 15px;
            right: 20px;
            pointer-events: none; 
            z-index: 50; 
            opacity: 0; 
            transition: opacity 0.3s ease; 
            
            /* Menggunakan flex column untuk menumpuk baris */
            display: flex; 
            flex-direction: column; /* Menumpuk ke bawah */
            align-items: flex-end; /* Rata kanan */
        }
        
        .watermark-line-1 {
            display: flex;
            align-items: center;
            gap: 8px; /* Jarak antara ikon dan teks */
            font-size: 20px;
            font-weight: bold;
            color: rgba(255, 255, 255, 0.6); 
            text-shadow: 1px 1px 2px #000;
        }

        .watermark .fab.fa-telegram {
            font-size: 24px; 
        }

        .watermark-line-2 {
            font-size: 12px; /* Ukuran font lebih kecil */
            font-weight: 500; /* Normal/medium */
            color: rgba(255, 255, 255, 0.5); /* Sedikit lebih transparan */
            text-shadow: 1px 1px 2px #000;
            margin-top: 2px; /* PERUBAHAN: Dibuat lebih dekat, dari 4px menjadi 2px */
        }

        .plyr--playing.plyr--hide-controls .watermark { opacity: 1; }
        .plyr--stopped .watermark,
        .plyr--paused .watermark { opacity: 0.5; }
        .plyr--has-controls:not(.plyr-hide-controls) .watermark { opacity: 0.2; }

        /* --- STYLING MODAL IKLAN --- */
        #ad-modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.85);
            display: none; /* Sembunyi by default, JS akan menampilkan */
            justify-content: center;
            align-items: center;
            z-index: 10000; /* Di atas segalanya */
            cursor: pointer;
            opacity: 0;
            transition: opacity 0.3s ease-out;
        }
        
        #ad-modal-content {
            background: #2d3436; /* Warna gelap */
            color: #dfe6e9; /* Warna teks terang */
            padding: 25px 35px;
            border-radius: 12px;
            text-align: center;
            max-width: 400px;
            margin: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            pointer-events: none; /* Biarkan klik menembus ke overlay */
        }
        
        /* CSS BARU: Untuk judul video di modal */
        #modal-video-title {
            margin: -5px 0 15px 0; /* Jarak atas/bawah */
            padding-bottom: 15px; /* Jarak bawah */
            border-bottom: 1px solid #4a4a4a; /* Garis pemisah */
            font-size: 1.25em; /* Ukuran font */
            font-weight: 600; /* Tebal */
            color: #fff; /* Warna putih */
            line-height: 1.4;
        }
        
        #ad-modal-content h3 {
            margin-top: 0;
            color: #fff;
            font-weight: 600;
        }
        #ad-modal-content p {
            font-size: 1.1em;
            line-height: 1.6;
            color: #b2bec3; /* Abu-abu terang */
        }
        #ad-modal-content p strong {
             color: #55efc4; /* Warna aksen (hijau mint) */
        }
        #ad-modal-content small {
            font-size: 0.9em;
            color: #636e72; /* Abu-abu gelap */
        }
        /* --- SELESAI STYLING MODAL --- */


        /* --- CSS BARU: MODAL PERINGATAN AD-BLOCKER --- */
        #ab-notice-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95); /* Lebih gelap */
            display: none; /* Sembunyi by default */
            justify-content: center;
            align-items: center;
            z-index: 20000; /* Di atas modal iklan */
            opacity: 0;
            transition: opacity 0.3s ease-out;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }

        #ab-notice-content {
            background: #c0392b; /* Latar merah */
            color: #fff;
            padding: 30px 40px;
            border-radius: 12px;
            text-align: center;
            max-width: 450px;
            margin: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
        }
        #ab-notice-content h3 {
            margin-top: 0;
            font-size: 1.5em;
            font-weight: 700;
            border-bottom: 2px solid rgba(255,255,255,0.3);
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        #ab-notice-content p {
            font-size: 1.15em;
            line-height: 1.7;
            margin: 0;
        }
         #ab-notice-content p strong {
             background: rgba(0,0,0,0.2);
             padding: 2px 6px;
             border-radius: 4px;
         }
        /* --- SELESAI CSS AD-BLOCKER --- */

    </style>
    
    <!-- 3. Muat HLS.js (WAJIB sebelum Plyr) --><script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.18/dist/hls.min.js"></script>
    <!-- 4. Muat Plyr.js --><script src="https://cdn.jsdelivr.net/npm/plyr@3.7.8/dist/plyr.polyfilled.min.js"></script>
</head>
<body>

    <!-- Watermark diletakkan langsung di body agar 'fixed' bekerja dengan baik -->
    <div class="watermark" id="watermark">
        <!-- Baris pertama: Ikon + Teks Utama -->
        <div class="watermark-line-1">
            <i class="fab fa-telegram"></i> <!-- Ikon Telegram -->
            <span>MOVIE CLUB</span>
        </div>
        <!-- Baris kedua: Teks Kecil -->
        <small class="watermark-line-2">@databasemovie_bot</small>
    </div>

    <!-- MODAL IKLAN BARU -->
    <div id="ad-modal-overlay">
        <div id="ad-modal-content">
            <!-- JUDUL VIDEO DITAMBAHKAN DARI PHP -->
            <h4 id="modal-video-title"><?= htmlspecialchars($title) ?></h4>
            
            <h3>Dukungan Anda Sangat Berarti</h3>
            <p>Untuk mendukung website ini, silakan <strong>klik di mana saja</strong> untuk membuka iklan (hanya sekali) dan memulai video.</p>
            <small>Terima kasih atas pengertian Anda!</small>
        </div>
    </div>
    
    <!-- MODAL PERINGATAN AD-BLOCKER BARU -->
    <div id="ab-notice-overlay">
        <div id="ab-notice-content">
            <h3>Ad-Blocker Terdeteksi!</h3>
            <p>Player ini didukung oleh iklan. Mohon <strong>nonaktifkan Ad-Blocker</strong> Anda di situs ini dan muat ulang halaman untuk memutar video.</p>
        </div>
    </div>


    <!-- Elemen Video HTML5 (target untuk Plyr) --><video 
        id="player" 
        playsinline 
        controls 
        poster="<?= htmlspecialchars($poster) ?>"
    ></video>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const video = document.getElementById('player');
            const watermark = document.getElementById('watermark');
            const source = <?= json_encode($proxyUrl) ?>; // URL .m3u8 dari PHP
            
            // --- PENGATURAN IKLAN ---
            const adUrl = 'https://www.effectivegatecpm.com//d1w5udhdr?key=3eab448debd3bd7f502f87896b3f36a9'; 
            let isFirstPlay = true; // Flag untuk memastikan iklan hanya muncul sekali
            const adModalOverlay = document.getElementById('ad-modal-overlay');
            const abNoticeOverlay = document.getElementById('ab-notice-overlay'); // Modal Ad-Blocker
            // --- SELESAI PENGATURAN IKLAN ---

            // Opsi untuk Plyr
            const plyrOptions = {
                controls: [
                    'play-large', // Tombol play besar di tengah
                    'restart',
                    'play',
                    'progress',
                    'current-time',
                    'duration',
                    'mute',
                    'volume',
                    'captions', // Jika ada VTT/SRT
                    'settings', // Menu Kualitas & Kecepatan
                    'pip',      // Picture-in-Picture
                    'airplay',  // AirPlay
                    'fullscreen'
                ],
                settings: ['quality', 'speed'],
                autoplay: false, // Autoplay harus mati agar modal berfungsi
                keyboard: { focused: true, global: true },
            };

            let player; // Variabel untuk instance Plyr

            // --- FUNGSI IKLAN MODAL BARU DENGAN DETEKSI AD-BLOCKER ---
            if (isFirstPlay && adModalOverlay && abNoticeOverlay) {
                // 1. Coba tampilkan modal iklan
                adModalOverlay.style.display = 'flex';

                // 2. Beri jeda singkat (50ms) agar browser/ad-blocker bisa bereaksi
                setTimeout(() => {
                    // 3. Periksa apakah modal iklan diblokir
                    const computedStyle = window.getComputedStyle(adModalOverlay);
                    if (computedStyle.display === 'none' || computedStyle.height === '0px' || computedStyle.visibility === 'hidden') {
                        // --- AD-BLOCKER TERDETEKSI ---
                        console.warn('Ad-Blocker terdeteksi, modal iklan utama diblokir.');
                        
                        // Sembunyikan modal iklan (untuk jaga-jaga)
                        adModalOverlay.style.display = 'none'; 
                        
                        // Tampilkan modal peringatan Ad-Blocker
                        abNoticeOverlay.style.display = 'flex';
                        setTimeout(() => { abNoticeOverlay.style.opacity = '1'; }, 10);

                        // Hentikan eksekusi, jangan pasang event listener klik
                        return; 

                    } else {
                        // --- TIDAK ADA AD-BLOCKER / MODAL AMAN ---
                        console.log('Modal iklan ditampilkan.');
                        
                        // Terapkan fade-in
                        adModalOverlay.style.opacity = '1';

                        // Pasang event listener HANYA jika modal tidak diblokir
                        adModalOverlay.addEventListener('click', () => {
                            if (isFirstPlay) {
                                isFirstPlay = false; // Set flag
                                
                                try {
                                    // Coba buka tab baru (INI DIPERBOLEHKAN karena dalam event klik)
                                    const adWindow = window.open(adUrl, '_blank');
                                    
                                    if (!adWindow || adWindow.closed || typeof adWindow.closed == 'undefined') {
                                        console.warn('Pop-up iklan diblokir.');
                                    } else {
                                        console.log('Iklan dibuka.');
                                    }
                                } catch (e) {
                                    console.error('Gagal membuka iklan:', e);
                                }
                            }
                            
                            // Sembunyikan modal
                            adModalOverlay.style.opacity = '0';
                            setTimeout(() => { adModalOverlay.style.display = 'none'; }, 300); // Tunggu transisi selesai
                            
                            // Mulai mainkan video
                            if (player) {
                                player.play();
                            }
                        });
                    }
                }, 50); // Jeda 50ms untuk deteksi

            } else if (!adModalOverlay) {
                 // Fallback jika modal iklan utamanya tidak ada di HTML
                 console.error('Elemen modal iklan tidak ditemukan. Memutar video secara langsung.');
                 // player.play(); // Jangan mainkan otomatis jika ada error
            }
            // --- SELESAI FUNGSI IKLAN MODAL ---


            if (window.Hls && Hls.isSupported()) {
                // --- KASUS 1: Browser butuh HLS.js (Chrome, Firefox) ---
                const hls = new Hls();
                hls.loadSource(source);
                hls.attachMedia(video);

                player = new Plyr(video, plyrOptions);

                // --- Pindahkan elemen watermark ke dalam container Plyr
                const plyrContainer = player.elements.container;
                if (plyrContainer) {
                    plyrContainer.appendChild(watermark);
                }
                // --- SELESAI PERBAIKAN ---

                hls.on(Hls.Events.MANIFEST_PARSED, (event, data) => {
                    // Buat daftar kualitas dari level HLS
                    const qualityOptions = hls.levels.map((level) => level.height).filter(Boolean);
                    
                    if (qualityOptions.length > 0) {
                        player.quality = {
                            default: hls.levels[hls.levels.length - 1].height, 
                            options: qualityOptions,
                            forced: true,
                            onChange: (newQuality) => {
                                hls.levels.forEach((level, levelIndex) => {
                                    if (level.height === newQuality) {
                                        hls.currentLevel = levelIndex;
                                    }
                                });
                            },
                        };
                    }
                });
                
                hls.on(Hls.Events.LEVEL_SWITCHED, (event, data) => {
                    const currentQuality = hls.levels[data.level].height;
                    player.config.quality.selected = currentQuality;
                });

                hls.on(Hls.Events.ERROR, function (event, data) {
                    if (data.fatal) {
                        console.error('HLS Error Fatal:', data.type, ':', data.details);
                        if (player) player.stop();
                        // Tampilkan error di modal Ad-Blocker jika ada, atau di modal utama
                        const noticeContent = document.getElementById('ab-notice-content');
                        if(noticeContent) {
                            noticeContent.innerHTML = '<h3>Error</h3><p>Gagal memuat video: ' + data.details + '</p>';
                            noticeContent.parentElement.style.display = 'flex';
                            noticeContent.parentElement.style.opacity = '1';
                            noticeContent.parentElement.style.background = 'rgba(0,0,0,0.9)'; // Latar hitam
                            noticeContent.style.background = '#4a4a4a'; // Latar abu-abu gelap
                        }
                    } else {
                        console.warn('HLS Error non-fatal:', data.type, ':', data.details);
                    }
                });

            } else if (video.canPlayType('application/vnd.apple.mpegURL')) {
                // --- KASUS 2: Browser mendukung HLS native (Safari, iOS) ---
                video.src = source;
                player = new Plyr(video, plyrOptions);

                // --- Pindahkan elemen watermark (untuk Safari/iOS) ---
                const plyrContainerSafari = player.elements.container;
                if (plyrContainerSafari) {
                    plyrContainerSafari.appendChild(watermark);
                }
                // --- SELESAI PERBAIKAN ---
            
            } else {
                // --- KASUS 3: Browser tidak mendukung HLS sama sekali ---
                console.error('Maaf, browser Anda tidak mendukung pemutaran HLS.');
                const noticeContent = document.getElementById('ab-notice-content');
                if(noticeContent) {
                    noticeContent.innerHTML = '<h3>Browser Tidak Mendukung</h3><p>Maaf, browser Anda tidak mendukung pemutaran video HLS.</p>';
                    noticeContent.parentElement.style.display = 'flex';
                    noticeContent.parentElement.style.opacity = '1';
                    noticeContent.parentElement.style.background = 'rgba(0,0,0,0.9)'; // Latar hitam
                    noticeContent.style.background = '#4a4a4a'; // Latar abu-abu gelap
                }
            }
            
            window.player = player; // Untuk debugging
        });
    </script>

</body>
</html>

